<?php
require __DIR__ . '/../src/bootstrap.php';

$pdo = db();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$dir = __DIR__ . '/migrations';
$files = glob($dir . '/*.sql');
sort($files);

try {
    foreach ($files as $file) {
        $sql = file_get_contents($file);
        if (trim($sql) === '') continue;
        echo "Running migration: " . basename($file) . "\n";
        $pdo->exec($sql);
    }
    echo "Migrations completed.\n";
} catch (Throwable $e) {
    fwrite(STDERR, 'Migration failed: ' . $e->getMessage() . "\n");
    exit(1);
}
