<?php
$config = require __DIR__ . '/config.php';

function db(): PDO {
    static $pdo = null;
    if ($pdo === null) {
        $cfg = require __DIR__ . '/config.php';
        $pdo = new PDO($cfg['db']['dsn'], $cfg['db']['user'], $cfg['db']['pass'], $cfg['db']['options']);
    }
    return $pdo;
}

function app_config(string $key = null) {
    static $cfg = null;
    if ($cfg === null) {
        $cfg = require __DIR__ . '/config.php';
    }
    if ($key === null) return $cfg;
    return $cfg[$key] ?? null;
}

function hmac_sign(array $params): string {
    ksort($params);
    $data = http_build_query($params, '', '&', PHP_QUERY_RFC3986);
    return hash_hmac('sha256', $data, app_config('signing_secret'));
}

function verify_signed_params(array $params, string $sig): bool {
    $p = $params;
    unset($p['sig']);
    if (isset($p['exp']) && (int)$p['exp'] < time()) {
        return false;
    }
    $expected = hmac_sign($p);
    return hash_equals($expected, $sig);
}

function json_response($data, int $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}
